/*
   Hyllian's Deposterizex Shader - pass0
   
   Copyright (C) 2011/2016 Hyllian/Jararaca - sergiogdb@gmail.com

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

/*
[configuration]

[OptionBool]
GUIName = deposterize-pass0
OptionName = DE0
DefaultValue = true

[/configuration]
*/

#define EQ  0.01
#define DF  0.06

float4 df4(float4 c1, float4 c2)
{
      return abs(c1 - c2);
}

bvec4 eq4(float4 A, float4 B)
{
	return (lessThanEqual(df4(A, B), float4(EQ, EQ, EQ, EQ)));
}


void main() {
    float4 color = Sample();
    if OptionEnabled(DE0) {
    

    float2 TexCoord_0 = GetCoordinates()-fp*GetInvResolution();
    float2 dx = float2(GetInvResolution().x, 0.0);
    float2 dy = float2(0.0, GetInvResolution().y);

    float4 D  = SampleLocation(TexCoord_0 - dx);
    float4 E  = SampleLocation(TexCoord_0);
    float4 F  = SampleLocation(TexCoord_0 + dx);

    color = ((!eq4(D, F)) && ((df4(E, F) <= float3(DF, DF, DF, DF)) && (eq4(D, E)) || (df4(D, E) <= float4(DF, DF, DF, DF)) && (eq4(E, F)))) ? 0.5*(D+F) : E;

	}
    SetOutput(color);
}


